
//************************TV  CONTROL RS-232 ****************************************************
//************************Programmer: Carl Fortin************************************************
//************************Language: XC8 *********************************************************


#include <xc.h>
#include  <string.h>
#include "serial.h"
#include "variable.h"

#define	_XTAL_FREQ 4000000                                                    

//Configuration bits dans le bootloader, aucun impacte si configur dans l'application
// CONFIG1
#pragma config FOSC = INTRC_NOCLKOUT// Oscillator Selection bits (INTOSCIO oscillator: I/O function on RA6/OSC2/CLKOUT pin, I/O function on RA7/OSC1/CLKIN)
#pragma config WDTE = ON      // Watchdog Timer Enable bit (WDT disabled and can be enabled by SWDTEN bit of the WDTCON register)
#pragma config PWRTE = OFF      // Power-up Timer Enable bit (PWRT disabled)
#pragma config MCLRE = ON       // RE3/MCLR pin function select bit (RE3/MCLR pin function is MCLR)
#pragma config CP = OFF         // Code Protection bit (Program memory code protection is disabled)
#pragma config CPD = OFF        // Data Code Protection bit (Data memory code protection is disabled)
#pragma config BOREN = OFF       // Brown Out Reset Selection bits (BOR enabled)
#pragma config IESO = ON        // Internal External Switchover bit (Internal/External Switchover mode is enabled)
#pragma config FCMEN = OFF      // Fail-Safe Clock Monitor Enabled bit (Fail-Safe Clock Monitor is disabled)
#pragma config LVP = OFF        // Low Voltage Programming Enable bit (RB3 pin has digital I/O, HV on MCLR must be used for programming)

// CONFIG2
#pragma config BOR4V = BOR40V   // Brown-out Reset Selection bit (Brown-out Reset set to 4.0V)
#pragma config WRT = OFF        // Flash Program Memory Self Write Enable bits (Write protection off)



/*                      DCLARATION DES PROTOTYPES DES FONCTIONS INTERNES                    */
/*                      *************************************************                    */


void Init_chip(void);
void Timer0_init (void);
void Timer_2_Init(void);
void Reset_timer_0 (void);
void Reset_timer_2 (void);
void led_test(void);
void LED_SW_TEST(void);
void Stop_timer_2(void);
void Stop_timer_0 (void);
void Get_Tv_status(void);
void delais_ouverture_tv (void);
void Read_Switch (unsigned char TV_Input);
void Set_Watchdog (void);
/*                               ENTRE DU PROGRAMME PRINCIPAL                               */
/*                               *****************************                               */


void main(void)

{                                               //Dbut du programme principale
    
    Init_chip();       //Initialisation du PIC
    Set_Watchdog();    //Setup watchdog
    serial_setup();    //Set Baud rate...
    led_test();        //LED Test
    LED_SW_TEST();     //Push button led test
    Timer_2_Init();     //Timer pour inttrupteur
    LED_DEBUG = 1;
    
       	while(1)
	{
             //Clear 2 seconds watchdog
             CLRWDT();
             //PUSH SW 1
             //Intruption dtect lis la push SW1 et si  un minimum de 1 seconde d'coul
             if (PUSH_SW1_FLAG  == 1)
              {
                //Debug
                //USARTWriteLine("SW_1");
                Read_Switch(1);
                PUSH_SW1_FLAG = 0;
                
               }
              
               //Timer de une seconde doit etre coul afin de valider un changement d'tat valide de l'intrrupteur (DEBOUNCE))
              if (Debounce_flag == 1 && SW1_INT_DETECTED  == 1)
              {
                    RBIE = 1;
                    SW1_INT_DETECTED = 0;
                    Stop_timer_2();
                    PUSH_SW1_FLAG = 1;
              }
            
             
             //PUSH SW 2
             if (PUSH_SW2_FLAG  == 1)
              {
                //Debug
                //USARTWriteLine("SW_2");
                Read_Switch(2);
                PUSH_SW2_FLAG = 0;
                
               }
                            
              if (Debounce_flag == 1 && SW2_INT_DETECTED  == 1)
              {
                    RBIE = 1;
                    SW2_INT_DETECTED = 0;
                    Stop_timer_2();
                    PUSH_SW2_FLAG = 1;
              }
             
             
             //PUSH SW 3
             if (PUSH_SW3_FLAG  == 1)
              {
                //Debug
                //USARTWriteLine("SW_3");
                Read_Switch(3);
                PUSH_SW3_FLAG = 0;
                
               }
                            
              if (Debounce_flag == 1 && SW3_INT_DETECTED  == 1)
              {
                    RBIE = 1;
                    SW3_INT_DETECTED = 0;
                    Stop_timer_2();
                    PUSH_SW3_FLAG = 1;
              }
             
             //PUSH SW 4
             if (PUSH_SW4_FLAG  == 1)
              {
                //Debug
                //USARTWriteLine("SW_4");
                Read_Switch(4);
                PUSH_SW4_FLAG = 0;
                
               }
                            
              if (Debounce_flag == 1 && SW4_INT_DETECTED  == 1)
              {
                    RBIE = 1;
                    SW4_INT_DETECTED = 0;
                    Stop_timer_2();
                    PUSH_SW4_FLAG = 1;
              }
             
              //PUSH SW 5
             if (PUSH_SW5_FLAG  == 1)
              {
                //Debug
                //USARTWriteLine("SW_5");
                Read_Switch(5);
                PUSH_SW5_FLAG = 0;
                
               }
                            
              if (Debounce_flag == 1 && SW5_INT_DETECTED  == 1)
              {
                    RBIE = 1;
                    SW5_INT_DETECTED = 0;
                    Stop_timer_2();
                    PUSH_SW5_FLAG = 1;
              }
             
              //PUSH SW 6 : Le bureau du prof projte sur tous les TV
             if (PUSH_SW6_FLAG  == 1)
              {
                //Debug
                //USARTWriteLine("SW_6");
                Read_Switch(6);
                PUSH_SW6_FLAG = 0;
                
               }
                            
              if (Debounce_flag == 1 && SW6_INT_DETECTED  == 1)
              {
                    RBIE = 1;
                    SW6_INT_DETECTED = 0;
                    Stop_timer_2();
                    PUSH_SW6_FLAG = 1;
              }
             
             
             //PUSH SW 7 : Allume et teint tous les TV LG en meme temps
             if (PUSH_SW7_FLAG  == 1)
              {
                //Debug
                //USARTWriteLine("SW_7");
                Read_Switch(7);
                PUSH_SW7_FLAG = 0;
                
               }
                            
              if (Debounce_flag == 1 && SW7_INT_DETECTED  == 1)
              {
                    RBIE = 1;
                    SW7_INT_DETECTED = 0;
                    Stop_timer_2();
                    PUSH_SW7_FLAG = 1;
              }
               
                       
             
             
    }
		
        

} //Fin du programme principale
	

void interrupt isr(void)
{

   
    
    
    //Push sw1-sw7 detected high on interrupt on change
    if(RBIF)
     {
        //LED_DEBUG = ~LED_DEBUG;
        unsigned char temp = 0;
        //Le port doit etre lu avant de pouvoir mettre le flag  zro
        temp = PORTB; 
        
        if (PORTBbits.RB0 == 0)
        {
         //Repart le timer qui assure 1 seconde de dlai entre le changement d'tat de l'intrrupteur   
         Reset_timer_2();
         Debounce_flag    = 0;
         SW1_INT_DETECTED = 1;
         //Dsactive l'interruption pour viter une seconde intteruption lorsque le port repasse  un niveau haut
         RBIE = 0;
         }
        
        if (PORTBbits.RB1 == 0)
        {
         Reset_timer_2();    
         Debounce_flag    = 0;
         SW2_INT_DETECTED = 1;
         RBIE = 0;
         }
        
        if (PORTBbits.RB2 == 0)
        {
         Reset_timer_2();    
         Debounce_flag    = 0;
         SW3_INT_DETECTED = 1;
         RBIE = 0;
         }
        
        //PROJETE SUR TOUS LES TV A PARTIR DU BUREAU DU PROF
         if (PORTBbits.RB3 == 0)
        {
         Reset_timer_2();    
         Debounce_flag    = 0;
         SW6_INT_DETECTED = 1;
         RBIE = 0;
         }
        
        if (PORTBbits.RB4 == 0)
        {
         Reset_timer_2();    
         Debounce_flag    = 0;
         SW4_INT_DETECTED = 1;
         RBIE = 0;
         }
        
        if (PORTBbits.RB5 == 0)
        {
         Reset_timer_2();    
         Debounce_flag    = 0;
         SW5_INT_DETECTED = 1;
         RBIE = 0;
         }
        
        //SW qui allume tous les TV
        if (PORTBbits.RB6 == 0)
        {
         Reset_timer_2();    
         Debounce_flag    = 0;
         SW7_INT_DETECTED = 1;
         RBIE = 0;
         }
       
        //Clear interruption flag
         RBIF=0;
     }
        
       
            
       //Timer 2 each 64 ms
      if (TMR2IE && TMR2IF == 1)
       {
             TV_sw_timer --;
             
             if (TV_sw_timer == 0)
             {
                 Debounce_flag = 1;
                 TV_sw_timer = Projo_sw_time;
                 
             }
             
             TMR2IF = 0;
        }
    
    
 }



void LED_SW_TEST (void)
{
LED_SW1 = 1;         
LED_SW2 = 1;        
LED_SW3 = 1;
LED_SW4 = 1;
LED_SW5 = 1;
LED_SW_ALL_TV = 1;
LED_SW_TV_ON = 1;
__delay_ms(200);
__delay_ms(200);
LED_SW1 = 0;         
LED_SW2 = 0;        
LED_SW3 = 0;
LED_SW4 = 0;
LED_SW5 = 0;
LED_SW_ALL_TV = 0;
LED_SW_TV_ON = 0;
__delay_ms(200);
__delay_ms(200);
LED_SW1 = 1;         
LED_SW2 = 1;        
LED_SW3 = 1;
LED_SW4 = 1;
LED_SW5 = 1;
LED_SW_ALL_TV = 1;
LED_SW_TV_ON = 1;
__delay_ms(200);
__delay_ms(200);
LED_SW1 = 0;         
LED_SW2 = 0;        
LED_SW3 = 0;
LED_SW4 = 0;
LED_SW5 = 0;
LED_SW_ALL_TV = 0;
LED_SW_TV_ON = 0;

}


void Read_Switch (unsigned char TV_Input)

{
  GIE = 0;
    
              
     switch (TV_Input)
     {

         case 1:
                //Remet l'tat des autres boutons  zro
                TV_2_Input = 0;   
                LED_SW2 = 0;   
                TV_3_Input = 0;   
                LED_SW3 = 0;
                TV_4_Input = 0;   
                LED_SW4 = 0;
                TV_5_Input = 0;   
                LED_SW5 = 0;
                Projo_Input = 0;   
                LED_SW_ALL_TV = 0;
                
                //Toggle tv state status  
                TV_1_Input = ~TV_1_Input;
                
                switch (TV_1_Input)
                {
                //Si aucune entre est slectionn, on remet l'entre du professeur par dfaut
                case 0:
                    LED_SW1 = 0;
                    USARTWriteLine("sw i06");
                break;

                 //Envoie la commande qui corespond  l'entre slectionn
                case 1:
                    LED_SW1 = 1;
                    USARTWriteLine("sw i01");
                break;
                }
          break;
          
         case 2:
             
               //Remet l'tat des autres boutons  zro
                TV_1_Input = 0;   
                LED_SW1 = 0;   
                TV_3_Input = 0;   
                LED_SW3 = 0;
                TV_4_Input = 0;   
                LED_SW4 = 0;
                TV_5_Input = 0;   
                LED_SW5 = 0;
                Projo_Input = 0;   
                LED_SW_ALL_TV = 0;
               
               //Toggle tv state status  
                TV_2_Input = ~TV_2_Input;
                switch (TV_2_Input)
                {
                //Si aucune entre est slectionn, on remet l'entre du professeur par dfaut
                case 0:
                    LED_SW2 = 0;
                    USARTWriteLine("sw i06");
                break;

                //Envoie la commande qui corespond  l'entre slectionn
                case 1:
                    LED_SW2 = 1;
                    USARTWriteLine("sw i02");
                break;
                }
          break;
          
          case 3:
             
               //Remet l'tat des autres boutons  zro
                TV_1_Input = 0;   
                LED_SW1 = 0;   
                TV_2_Input = 0;   
                LED_SW2 = 0;
                TV_4_Input = 0;   
                LED_SW4 = 0;
                TV_5_Input = 0;   
                LED_SW5 = 0;
                Projo_Input = 0;   
                LED_SW_ALL_TV = 0;
               
               //Toggle tv state status  
                TV_3_Input = ~TV_3_Input;
                switch (TV_3_Input)
                {
                //Si aucune entre est slectionn, on remet l'entre du professeur par dfaut
                case 0:
                    LED_SW3 = 0;
                    USARTWriteLine("sw i06");
                break;

                //Envoie la commande qui corespond  l'entre slectionn
                case 1:
                    LED_SW3 = 1;
                    USARTWriteLine("sw i03");
                break;
                }
          break;
          
          case 4:
             
               //Remet l'tat des autres boutons  zro
                TV_1_Input = 0;   
                LED_SW1 = 0;   
                TV_2_Input = 0;   
                LED_SW2 = 0;
                TV_3_Input = 0;   
                LED_SW3 = 0;
                TV_5_Input = 0;   
                LED_SW5 = 0;
                Projo_Input = 0;   
                LED_SW_ALL_TV = 0;
               
               //Toggle tv state status  
                TV_4_Input = ~TV_4_Input;
                switch (TV_4_Input)
                {
                //Si aucune entre est slectionn, on remet l'entre du professeur par dfaut
                case 0:
                    LED_SW4 = 0;
                    USARTWriteLine("sw i06");
                break;

                //Envoie la commande qui corespond  l'entre slectionn
                case 1:
                    LED_SW4 = 1;
                    USARTWriteLine("sw i04");
                break;
                }
          break;
          
     case 5:
             
               //Remet l'tat des autres boutons  zro
                TV_1_Input = 0;   
                LED_SW1 = 0;   
                TV_2_Input = 0;   
                LED_SW2 = 0;
                TV_4_Input = 0;   
                LED_SW4 = 0;
                TV_3_Input = 0;   
                LED_SW3 = 0;
                Projo_Input = 0;   
                LED_SW_ALL_TV = 0;
               
               //Toggle tv state status  
                TV_5_Input = ~TV_5_Input;
                switch (TV_5_Input)
                {
                //Si aucune entre est slectionn, on remet l'entre du professeur par dfaut
                case 0:
                    LED_SW5 = 0;
                    USARTWriteLine("sw i06");
                break;

                //Envoie la commande qui corespond  l'entre slectionn
                case 1:
                    LED_SW5 = 1;
                    USARTWriteLine("sw i05");
                break;
                }
    break;
    
    
    //Projo Input
    case 6:
             
               //Remet l'tat des autres boutons  zro
                TV_1_Input = 0;   
                LED_SW1 = 0;   
                TV_2_Input = 0;   
                LED_SW2 = 0;
                TV_3_Input = 0;   
                LED_SW3 = 0;
                TV_4_Input = 0;   
                LED_SW4 = 0;
                TV_5_Input = 0;   
                LED_SW5 = 0;
                               
               
               //Toggle tv state status  
                Projo_Input = ~Projo_Input;
                switch (Projo_Input)
                {
                //Si on dselectionne, on remet l'entre des TV LG sur HDMI 1
                case 0:
                    LED_SW_ALL_TV = 0;
                    USARTWriteLine(TV_INPUT_HDMI_1);  
                 
                break;

                //Envoie la commande qui change les input sur les TV LG  HDMI2 (La source est le splitter 8 ports)
                case 1:
                    LED_SW_ALL_TV = 1;
                    USARTWriteLine(TV_INPUT_HDMI_2);   
                break;
                }
    break;
    
    //All TV ON or OFF
    case 7:
             
               //Remet l'tat des autres boutons  zro
                TV_1_Input = 0;   
                LED_SW1 = 0;   
                TV_2_Input = 0;   
                LED_SW2 = 0;
                TV_3_Input = 0;   
                LED_SW3 = 0;
                TV_4_Input = 0;   
                LED_SW4 = 0;
                TV_5_Input = 0;   
                LED_SW5 = 0;
                Projo_Input = 0; 
                LED_SW_ALL_TV = 0;               
               
               //Toggle tv state power status  
                All_Tv_State = ~All_Tv_State;
                switch (All_Tv_State)
                {
                //Si on dselectionne, on ferme toutes les TV LG
                case 0:
                    LED_SW_TV_ON = 0;
                    USARTWriteLine(TURN_OFF_ALL_TV);  
                 
                break;

                //Envoie la commande pour ouvrir toutes les TV LG
                case 1:
                    LED_SW_TV_ON = 1;
                    //Baud rate de 9600 car les TV allume seuleument avec 9600 lorsqu'ils sont teints
                    //Les autres commandes fonctionnent quand meme  19200.
                    SPBRG=25;
                    BRGH=1;	         //data rate for sending
                    SYNC=0;			 //asynchronous
                    SPEN=1;			 //enable serial port pins
                    USARTWriteLine(TURN_ON_ALL_TV);
                    USARTWriteLine(TURN_ON_ALL_TV);
                    //On remet le baud rate  19200 pour les autres commandes et le splitter HDMI
                    SPBRG=12;
                    BRGH=1;	         //data rate for sending
                    SYNC=0;			 //asynchronous
                    SPEN=1;			 //enable serial port pins
                break;
                }
    break;




 }//End swith case
 
  GIE = 1;
  
} //End Read_Switch



void delais_ouverture_tv (void)

{
//Delais pour donner le temps  la tv de s'ouvrir
     __delay_ms(250);
     __delay_ms(250);
     __delay_ms(250);
     __delay_ms(250);
     
     __delay_ms(250);
     __delay_ms(250);
     __delay_ms(250);
     __delay_ms(250);
     
     __delay_ms(250);
     __delay_ms(250);
     __delay_ms(250);
     __delay_ms(250);
     
 }

void Reset_timer_0 (void)
{
TMR0IE = 1;                  //Interruption permise
TMR0IF = 0;
TMR0   = 0;                  //Commence a compter a 0
TV_sw_timer = Projo_sw_time;
}

void Reset_timer_2 (void)
{
//Ractive interruption du timer 2
TMR2IE = 1;
TMR2IF = 0;
TMR2   = 0;  
TV_sw_timer = Projo_sw_time;
}


void Stop_timer_2 (void)
{
//Dsactive interruption du timer 2
TMR2IE = 0;
TV_sw_timer = Projo_sw_time;

}

void Stop_timer_0 (void)

{
TMR0IE = 0;   //Dsactive intruption du timer 0
TV_sw_timer = Projo_sw_time;
}

void Timer0_init (void)

{
    /*                                    Initialisation du timer0                                */

    INTEDG = 0;                  //Interrupt on the falling edge
    T0SE = 0;                  //Timer0 aliment par clock interne
    PSA    = 0;                  //Le prescaler est pour le timer0
    PS0    = 1;                  //(Fosc / 4) = 1 Mhz Divis par 256 pour une frquence de 4KHz = 250 Us par coup de clock
    PS1    = 1;
    PS2    = 1;
    TMR0IE = 0;                  //Dsactive intruption du timer 0 au dpart
    TMR0IF = 0;
    TMR0   = 0;                  //Commence a compter a 0

}


void Set_Watchdog (void)
{
 PSA    = 1; //Prescaler is assigned to the WDT 
 //Watchdog prescaler shared with timer 0
 PS0    = 1; //(WDT 16 ms par dfaut) X (Prescaler 128) pour donner 2 secondes
 PS1    = 1;
 PS2    = 1;
 
 //Watchdog prescaler
 WDTPS3 = 0;  //31000/512 = 60 Hz = 16 ms (Reset value)
 WDTPS2 = 1;
 WDTPS1 = 0;
 WDTPS0 = 0;
 SWDTEN = 1;  //Software Enable or Disable the Watchdog Timer If WDTE configuration bit = 1, then WDT is always enabled 

}

void Timer_2_Init (void)

{

//Timer2 Registers Prescaler= 16 - TMR2 PostScaler = 16 - PR2 = 255 - Freq = 15.32 Hz - Period = 0.065280 seconds
T2CON |= 120;        // bits 6-3 Post scaler 1:1 thru 1:16
TMR2ON = 1;  // bit 2 turn timer2 on;
T2CKPS1 = 1; // bits 1-0  Prescaler Rate Select bits
T2CKPS0 = 0;
PR2 = 255;         // PR2 (Timer2 Match value)

TMR2IF = 0;        	// clear timer2 interupt flag TMR1IF
TMR2IE = 0;         // Dsactive les intruptions du Timer2 au dpart
TMR2   = 0;  

}


void led_test (void)
{
    
LED_DEBUG = 1;
__delay_ms(200);
LED_DEBUG = 0;
__delay_ms(200);
LED_DEBUG = 1;
__delay_ms(200);
LED_DEBUG = 0;
__delay_ms(200);
LED_DEBUG = 1;

}

//Non utilis
void Get_TV_status(void)

{
        
        USARTWriteLine(Projo_PWR_STATUS); //Poll projecteur pour connaitre son statut
        //Active reception sur port srie seulement apres avoir demand l'tat du projecteur
        CREN=1;
}


void Init_chip (void)

{
OSCCON = 0b01101010;  //OSCILLATOR CONTROL REGISTER
         //0-------   Software PLL Enable bit
         //-1101---   Internal Oscillator Frequency Select bits (4MHz)
         //------10   System Clock Select bits






OPTION_REG = 0b00000000;  //TMR0  prescaler/WDT  postscaler 
             //0-------   RBPU Weak pull-ups are enabled by individual WPUx latch values
             //-0------	  INTEDG: Interrupt Edge Select bit
             //--0-----   T0CS: TMR0 Clock Source Select bit
             //---0----   T0SE: TMR0 Source Edge Select bit
             //----0---   PSA: Prescaler Assignment bit
             //-----000   PS2:PS0: Prescaler Rate Select bits    

INTCON = 0b01001000;  //Register is a readable and writable register, which contains various enable and flag bits
         //0-------   GIE: Global Interrupt Enable bit
         //-1------   PEIE: Peripheral Interrupt Enable bit
         //--0-----   TOIE
         //---0----   INTE
         //----1---   RBIE
         //-----0--   T0IF
         //------0-   INTF
         //-------0   RBIF

PIE1 = 0b00000000;   //The PIE1 register contains the individual enable bits for the peripheral interrupts.
       //0-------    PSPIE(1): Parallel Slave Port Read/Write Interrupt Enable bit
       //-0------    ADIE:     A/D Converter Interrupt Enable bit
       //--0-----    RCIE:     USART Receive Interrupt Enable bit
       //---0----    TXIE:     USART Transmit Interrupt Enable bit
       //----0---    SSPIE:    Synchronous Serial Port Interrupt Enable bit
       //-----0--    CCP1IE:   CCP1 Interrupt Enable bit
       //------0-    TMR2IE:   TMR2 to PR2 Match Interrupt Enable bit
       //-------0    TMR1IE:   TMR1 Overflow Interrupt Enable bit
	   
	   
PIE2 = 0b00000000;   //Individual enable bits for the  CCP2  peripheral  interrupt
       //-0------	  Reserved Always maintain this bit clear
	   //---0----     EEPROM Write Operation Interrupt Enable
	   //----0---     BCLIE:  Bus Collision Interrupt Enable
	   //-------0     CCP2IE: CCP2 Interrupt Enable bit
	   	   
PIR1 = 0b00000000;   //Individual flag bits for the peripheral interrupts.
       //0-------    PSPIF:  Parallel Slave Port Read/Write Interrupt Flag bit
	   //-0------	 ADIF:   A/D Converter Interrupt Flag bit
	   //--0-----    RCIF:   USART Receive Interrupt Flag bit
	   //---0----    TXIF:   USART Transmit Interrupt Flag bit
	   //----0---    SSPIF:  Synchronous Serial Port (SSP) Interrupt Flag
	   //-----0--    CCP1IF: CCP1 Interrupt Flag bit
	   //------0-    TMR2IF: TMR2 to PR2 Match Interrupt Flag bit
	   //-------0    TMR1IF: TMR1 Overflow Interrupt Flag bit

ANSELH = 0b00000000;     //Digital I/O. Pin is assigned to port or special function

TRISA =  0b00000000;	 //RA0-RA7 en sortie
PORTA =  0;		         //Tout est  zro en partant

TRISB =  0b11111111;	 //Port B en entre pour tous les ports
WPUB  =  0b11111111;     //Weak pullup enabled on all port for 7 push buttons

TRISC =  0b10000000;	 //RC0-RC6 en sortie et RC7 en entre pour RX
PORTC =  0;		         //Tout est  zro en partant

TRISD =  0b00000000;	 //RD0-RD7 en sortie pour LED des Push button
PORTD =  0;		         //Tout est  zro en partant



//Interrupt-on-Change enabled on all the pin of PORT B

IOCB =  0b11111111;

GIE = 1;           //Interruption globale permise

}